#ifndef MUNGE_API_H
#define MUNGE_API_H

/* util.c */
void flushline(void);
int type(int);
int push(int);
int pop(void);
void fx_init(void);

/* fio.c */
int openf(char*);
void closef(int);
int Getc(void);
void Ungetc(int);
void pbstr(char*);
void prlist(char*);
void error(char*, char*, ...);
void errout(char*, ...);
void synerr(char*, char*, ...);

/* parse.c */
int gettok(char*, int);
int chkmaj(void);
void parse(void);

/* compile.c */
void compile(int);
int adv_getline(char*, int);
int munge_eval(char*);

/* buffers.c */
void clrcode(void);
void clrtext(void);
void apptext(char*);
void outtext(int);
void outcode(int);
void appcode(short int);

/* majors.c */
void act(void);
void def(void);
void at(void);
void def(void);
void inc(void);
void init(void);
void lab(void);
void null(void);
void obj(void);
void place(void);
void rep(void);
void syn (void);
void text(void);
void var(void);
void verb(void);

/* symtab.c */
void wstab(void);

#endif
