/* parser.h:  parser header file */

/* ACTIONS */
#define A_SKIP 1
#define A_COPY 2
#define A_EXPON 3
#define A_EXPOFF 4
#define A_INC 5
#define A_MSG 6
#define A_ERR 7
#define A_NOP 8
#define A_DUMPSYM 9

/* ERROR CODES */
#define E_NUMBER 100	/* Error message number baseline */
#define E_BADEF 101		/* Unable to define symbol */
#define E_BADSTR 102	/* Unterminated string */
#define E_BADSYM 103	/* Use of unassigned symbol */
#define E_SYMEXP 104	/* Symbol expected */
#define E_TYPEDIFF 105	/* Operand types do not match */
#define E_BADTYPE 106	/* Unknown type in expression */
#define E_ASSFAIL 107	/* Unable to assign value to symbol */
#define E_STREXP 108	/* String expected */
#define E_BADEXP 109	/* Illegal expression */
#define E_DIVZERO 110	/* Attempt to divide by zero */
#define E_NOMEM 111		/* Insufficient memory */
#define E_BADINT 112	/* Integer expected */
#define E_BADKEY 113    /* Unknown keyword */
#define E_STKOVR 114    /* Stack overflow */
#define E_STKUDR 115    /* Stack underflow */
#define E_STKEMP 116    /* Stack empty */
#define E_INTERNAL 117  /* internal error */

extern bool debug;
extern int parse_error;

/* DEBUG macro for printing varying number of args */
#define DEBUGV(format, ...) \
    if (debug) fprintf(stderr,format, __VA_ARGS__); \

/* function prototypes */
VAR *parse_expression(int);
int parse_statement(char*, char*, int);
const char *parse_geterrmsg(int);
