#!/usr/local/bin/python
"""
NAME

  chk_xml.py -  Validate XML using libxml2

SYNOPSIS

  python chk_xml.py [-v] [-f catalog_file] file [file ...]

  where:
    -v               verbose
    -f catalog_file  define location of local DTD catalog file
    -x               force check to return true
    file             name of file to be checked

DESCRIPTION

  Validates XML files using the python bindings to libxml2.
  Errors in the XML file are written to sys.stdout and cause
  chk_xml.py to return a non-zero exit code.

  If you have local copies of the DTDs and other supporting files,
  specify the catalog file name to chk_xml.py via the -f argument.
  This makes chk_xml.py much faster.

NOTES

  This is really just a wrapper around the validate.py test case,
  provided by python bindings to libxml2.

MODIFICATION HISTORY
  Mnemonic   Rel   Date     Who
  chk_xml    1.0   20050924 mpw
     Created.

$Id: chk_xml.py,v 1.1 2014/04/18 19:45:45 mark Exp $
"""

import libxml2
import sys
import getopt
import os
    
verbose = False
catfile = ""
force_ok = False

try:
    opts,args = getopt.getopt(sys.argv[1:],'vf:x')
    for o,v in opts:
        if o == '-v':
            verbose = True
        elif o == '-f':
            catfile = v
        elif o == "-x":
            force_ok = True
except getopt.GetoptError,e:
    print "%s: illegal argument: %s" % (sys.argv[0],e.opt)
    sys.exit(1)

if force_ok: sys.exit(0)

if catfile != "":
    if not os.path.exists(catfile):
        print >>sys.stderr,"%s: no such catalog as %s" % (sys.argv[0],\
                                                      catfile)
        sys.exit(2)
    else:
        libxml2.loadCatalog(catfile)

for f in args:
    if os.path.exists(f):
        ctxt = libxml2.createFileParserCtxt(f)
        ctxt.validate(1)
        ctxt.parseDocument()
        doc = ctxt.doc()
        valid = ctxt.isValid()
        doc.freeDoc()
        if valid != 1:
            print "Invalid XML"
            sys.exit(1)
    else:
        print >>std.syserr,"%s: unable to open file: %s" % (sys.argv[0],\
                                                            f)
